/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.casting.material;

import com.google.gson.JsonObject;
import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3956;
import net.minecraft.class_5455;
import slimeknights.mantle.recipe.IMultiRecipe;
import slimeknights.mantle.recipe.helper.RecipeHelper;
import slimeknights.tconstruct.library.materials.definition.MaterialVariant;
import slimeknights.tconstruct.library.recipe.TinkerRecipeTypes;
import slimeknights.tconstruct.library.recipe.casting.AbstractCastingRecipe;
import slimeknights.tconstruct.library.recipe.casting.DisplayCastingRecipe;
import slimeknights.tconstruct.library.recipe.casting.ICastingContainer;
import slimeknights.tconstruct.library.recipe.casting.ICastingRecipe;
import slimeknights.tconstruct.library.recipe.casting.IDisplayableCastingRecipe;
import slimeknights.tconstruct.library.recipe.casting.material.MaterialCastingLookup;
import slimeknights.tconstruct.library.recipe.casting.material.MaterialFluidRecipe;
import slimeknights.tconstruct.library.tools.part.IMaterialItem;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public abstract class MaterialCastingRecipe
extends AbstractCastingRecipe
implements IMultiRecipe<IDisplayableCastingRecipe> {
    protected final int itemCost;
    protected final IMaterialItem result;
    protected Optional<MaterialFluidRecipe> cachedFluidRecipe = Optional.empty();
    protected List<IDisplayableCastingRecipe> multiRecipes;

    public MaterialCastingRecipe(class_3956<?> type, class_2960 id, String group, class_1856 cast, int itemCost, IMaterialItem result, boolean consumed, boolean switchSlots) {
        super(type, id, group, cast, consumed, switchSlots);
        this.itemCost = itemCost;
        this.result = result;
        MaterialCastingLookup.registerItemCost(result, itemCost);
    }

    protected Optional<MaterialFluidRecipe> getMaterialFluid(ICastingContainer inv) {
        return MaterialCastingLookup.getCastingFluid(inv);
    }

    protected Optional<MaterialFluidRecipe> getCachedMaterialFluid(ICastingContainer inv) {
        Optional<MaterialFluidRecipe> fluidRecipe = this.cachedFluidRecipe;
        if (fluidRecipe.filter(recipe -> recipe.matches(inv)).isEmpty() && (fluidRecipe = this.getMaterialFluid(inv)).isPresent()) {
            this.cachedFluidRecipe = fluidRecipe;
        }
        return fluidRecipe;
    }

    public boolean matches(ICastingContainer inv, class_1937 worldIn) {
        if (!this.cast.method_8093(inv.getStack())) {
            return false;
        }
        return this.getCachedMaterialFluid(inv).filter(recipe -> this.result.canUseMaterial(recipe.getOutput().getId())).isPresent();
    }

    @Override
    public int getCoolingTime(ICastingContainer inv) {
        return this.getCachedMaterialFluid(inv).map(recipe -> ICastingRecipe.calcCoolingTime(recipe.getTemperature(), recipe.getFluidAmount(inv.getFluid()) * (long)this.itemCost)).orElse(1);
    }

    @Override
    public long getFluidAmount(ICastingContainer inv) {
        return this.getCachedMaterialFluid(inv).map(recipe -> recipe.getFluidAmount(inv.getFluid())).orElse(1L) * (long)this.itemCost;
    }

    @Override
    public class_1799 method_8110(class_5455 registryAccess) {
        return new class_1799((class_1935)this.result);
    }

    public class_1799 assemble(ICastingContainer inv, class_5455 registryAccess) {
        MaterialVariant material = this.getCachedMaterialFluid(inv).map(MaterialFluidRecipe::getOutput).orElse(MaterialVariant.UNKNOWN);
        return this.result.withMaterial(material.getVariant());
    }

    protected List<FluidStack> resizeFluids(List<FluidStack> fluids) {
        if (this.itemCost != 1) {
            return fluids.stream().map(fluid -> new FluidStack(fluid, fluid.getAmount() * (long)this.itemCost)).collect(Collectors.toList());
        }
        return fluids;
    }

    @Override
    public List<IDisplayableCastingRecipe> getRecipes() {
        if (this.multiRecipes == null) {
            class_3956<?> type = this.method_17716();
            List<class_1799> castItems = Arrays.asList(this.cast.method_8105());
            this.multiRecipes = MaterialCastingLookup.getAllCastingFluids().stream().filter(recipe -> {
                MaterialVariant output = recipe.getOutput();
                return !output.isUnknown() && !output.get().isHidden() && this.result.canUseMaterial(output.getId());
            }).map(recipe -> {
                List<FluidStack> fluids = this.resizeFluids(recipe.getFluids());
                long fluidAmount = fluids.stream().mapToLong(FluidStack::getAmount).max().orElse(0L);
                return new DisplayCastingRecipe(type, castItems, fluids, this.result.withMaterial(recipe.getOutput().getVariant()), ICastingRecipe.calcCoolingTime(recipe.getTemperature(), (long)this.itemCost * fluidAmount), this.consumed);
            }).collect(Collectors.toList());
        }
        return this.multiRecipes;
    }

    public static class Serializer<T extends MaterialCastingRecipe>
    extends AbstractCastingRecipe.Serializer<T> {
        private final IFactory<T> factory;

        @Override
        protected T create(class_2960 idIn, String groupIn, @Nullable class_1856 cast, boolean consumed, boolean switchSlots, JsonObject json) {
            int itemCost = class_3518.method_15260((JsonObject)json, (String)"item_cost");
            IMaterialItem result = RecipeHelper.deserializeItem(class_3518.method_15265((JsonObject)json, (String)"result"), "result", IMaterialItem.class);
            return this.factory.create(idIn, groupIn, cast, itemCost, result, consumed, switchSlots);
        }

        @Override
        protected T create(class_2960 idIn, String groupIn, @Nullable class_1856 cast, boolean consumed, boolean switchSlots, class_2540 buffer) {
            int fluidAmount = buffer.readInt();
            IMaterialItem result = RecipeHelper.readItem(buffer, IMaterialItem.class);
            return this.factory.create(idIn, groupIn, cast, fluidAmount, result, consumed, switchSlots);
        }

        @Override
        protected void writeExtra(class_2540 buffer, MaterialCastingRecipe recipe) {
            buffer.writeInt(recipe.itemCost);
            RecipeHelper.writeItem(buffer, recipe.result);
        }

        public Serializer(IFactory<T> factory) {
            this.factory = factory;
        }
    }

    public static interface IFactory<T extends MaterialCastingRecipe> {
        public T create(class_2960 var1, String var2, @Nullable class_1856 var3, int var4, IMaterialItem var5, boolean var6, boolean var7);
    }

    public static class Table
    extends MaterialCastingRecipe {
        public Table(class_2960 id, String group, class_1856 cast, int itemCost, IMaterialItem result, boolean consumed, boolean switchSlots) {
            super((class_3956)TinkerRecipeTypes.CASTING_TABLE.get(), id, group, cast, itemCost, result, consumed, switchSlots);
        }

        public class_1865<?> method_8119() {
            return (class_1865)TinkerSmeltery.tableMaterialSerializer.get();
        }
    }

    public static class Basin
    extends MaterialCastingRecipe {
        public Basin(class_2960 id, String group, class_1856 cast, int itemCost, IMaterialItem result, boolean consumed, boolean switchSlots) {
            super((class_3956)TinkerRecipeTypes.CASTING_BASIN.get(), id, group, cast, itemCost, result, consumed, switchSlots);
        }

        public class_1865<?> method_8119() {
            return (class_1865)TinkerSmeltery.basinMaterialSerializer.get();
        }
    }
}

